/******************************************************************************/
#include "stdafx.h"
/******************************************************************************

   FileText is meant for operations performed on a text file

/******************************************************************************/
struct Data // custom Data structure to test text file saving/loading
{
   Flt  volume;
   Int  graphics_mode;
   Char player_name[64];

   Bool saveTxt(Char *name); // save data to   text file
   Bool loadTxt(Char *name); // load data from text file
};
/******************************************************************************/
Bool Data::saveTxt(Char *name)
{
   FileText f; // FileText object

   if(f.write(name)) // if file opened successfully
   {
      f.put    ("Volume       = ",volume       );
      f.put    ("GraphicsMode = ",graphics_mode); // please note "GraphicsMode" is used instead of "Graphics Mode" (names are required to don't have spaces)
      f.putName("PlayerName   = ",player_name  ); // FileText::putName will automatically put the value in quotes
      return true; // return success
   }
   return false; // return failure
}

Bool Data::loadTxt(Char *name)
{
   // set default values to members in case file not found or file incomplete
   volume=1;
   graphics_mode=5;
   player_name[0]=0;

   FileText f;

   if(f.read(name)) // if file opened successfully
   {
      for(;f.level();) // process file within its level
      {
         if(f.cur("Volume"      ))volume       =Sat(f.getReal()     );else // if encountered "Volume"       read a floating point value, saturate it and store into 'value'
         if(f.cur("GraphicsMode"))graphics_mode=Mid(f.getInt (),0,10);else // if encountered "GraphicsMode" read a integer        value, clamp    it and store into 'graphics_mode'
         if(f.cur("PlayerName"  ))f.getName(player_name);                  // if encountered "PlayerName"   read a string using 'FileText::getName' method     into 'player_name'
      }
      return true; // return success
   }
   return false; // return failure
}
/******************************************************************************/
void InitPre()
{
   App.name="FileText";
   App.flag=APP_NO_FX;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   // set sample data values
   Data data;
       data.volume       =0.5;
       data.graphics_mode=2;
   Set(data.player_name,"He-Man");

   data.saveTxt("Data/file.txt"); // save data to   text file
   data.loadTxt("Data/file.txt"); // load data from text file

   OSLaunch("Data/file.txt"); // open the text file in default Windows viewer to check what actually has been saved

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);
}
/******************************************************************************/
